# Webform预览调试说明

## 打包webform文件

> 此处介绍的是zxl_pm预览专用的命令，其他命令参考项目中的package.json

进入webform目录，将webform的组件打包为umd文件，输出文件夹名为dist

~~~powershell
npm run build:preview
~~~

## 调试

要调试修改后的webform，目前没有一种好的手段支持实时的调试，需要手动打包之后再调试。

为了省去复制粘贴打包文件的这步，在本地开发环境中打开powershell，输入以下命令：

步骤一：调试前先删除文件：

~~~powershell
Remove-Item -Path "你的zxl_pm项目目录\public\form-engine-env" -Recurse && Remove-Item -Path "你的gx基座项目目录\public" -Recurse
~~~

步骤二：将打包的umd文件映射到`zxl_pm项目目录\public\form-engine-env`目录：

~~~powershell
 cd "你的zxl_pm项目目录\public\form-engine-env"
 New-Item -ItemType Junction -Path "assets" -Target "你的webform项目目录\dist"
~~~
步骤三：将整个form-engine-env资源映射到gx基座项目目录：
~~~powershell
 cd "你的gx基座项目目录\public"
 New-Item -ItemType Junction -Path "form-engine-env" -Target "你的zxl_pm项目目录\public\form-engine-env"
~~~

## 更新到SVN

1、将gx基座更新到SVN时，不要提交`你的gx基座项目目录\public`目录下的form-engine-env文件夹，这个文件夹仅用于调试。

2、将zxl_pm更新到SVN时，要手动删除映射到"你的zxl_pm项目目录\public\form-engine-env"目录下的assets文件夹，因为这个属于软连接，svn不识别。需要手动重新创建assets文件夹，真实地复制打包好的webform文件到assets文件夹中。

