const insideWindow = window; //为了便于阅读，以区分外层的window
let xmlData = "";
// 实例化Vue2应用
new Vue({
  el: "#app",
  data: () => {
    return {
      loadXMLConfig: { headers: { Pragma: "no-cache", "Cache-Control": "no-cache" } },
      localMode: true,
      xmlData,
    };
  },
  mounted() {
    //接受外部信息
    insideWindow.addEventListener("message", (event) => {
      // 验证消息来源
      // 例如：if (event.origin !== 'https://your-website.com') return;
      const eventsMap = {
        renderXML: () => {
          this.xmlData = event.data.xmlData;
          this.$nextTick(() => {
            // console.log("Received message from outside:event,this.xmlData", event, this.xmlData);
            insideWindow.parent.postMessage({ eventName: "changeHeight", params: { height: document.querySelector("#app").clientHeight } }, "*");
          });
        },
        // captureXMLScreen: () => {
        //   insideWindow.parent.postMessage({ eventName: "captureXMLScreen_response", params: { DOMNode: document.querySelector("body") } }, "*");
        //   event.data.handler();
        // },
      };

      // 处理接收到的消息
      if (eventsMap[event.data?.eventName]) eventsMap[event.data.eventName]();
    });
  },
  components: {
    "form-engine": insideWindow["form-engine"], //umd文件直接将form-engine挂载到window上，直接读取
  },
});
insideWindow.parent.postMessage({ eventName: "insideLoadFinish" }, "*");
// insideWindow.addEventListener("click", (e) => {
//   console.log("click event form inside", e);
//   insideWindow.parent.postMessage("xixi", "*");
// });
