(function () {
  window.onload = () => {
    var server = window.__SYSTEM_CONFIG__.BASE_FRAME_PROMGRAM_URL || './';
    server = server.endsWith('/') ? server : server + '/';

    // 挂载 favicon
    var favicon = document.createElement('link');
    favicon.rel = 'icon';
    favicon.type = 'image/x-icon';
    favicon.href = server + 'image/logo.png';
    document.head.appendChild(favicon);

    // 挂载固定资源
    [
      'index.min.css',
      'lib/element-plus-index@@2.3.4.css',
      'cssvar.css'
    ].forEach(function (href) {
      var link = document.createElement('link');
      link.rel = 'stylesheet';
      link.href = server + href;
      document.head.appendChild(link);
    });

    // 挂载主产物 CSS
    var mainCss = document.createElement('link');
    mainCss.rel = 'stylesheet';
    mainCss.href = server + "assets/" + "index-BCTrP-FJ.css";
    document.head.appendChild(mainCss);

    // 挂载主产物 JS
    var mainJs = document.createElement('script');
    mainJs.type = 'module';
    mainJs.src = server + "assets/" + "index-B_MhHF4m.js";
    var insertNode = document.getElementById('script-injector');
    if (insertNode && insertNode.parentNode) {
      insertNode.parentNode.insertBefore(mainJs, insertNode);
    } else {
      document.body.appendChild(mainJs);
    }
  }
})();